/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.util.ArrayList;
import java.util.List;
import org.python.core.ArgParser;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyIterator;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyXRange;
import org.python.modules.PyTeeIterator;

public class itertools
implements ClassDictInit {
    public static PyString __doc__ = new PyString("Functional tools for creating and using iterators.\n\nInfinite iterators:\ncount([n]) --> n, n+1, n+2, ...\ncycle(p) --> p0, p1, ... plast, p0, p1, ...\nrepeat(elem [,n]) --> elem, elem, elem, ... endlessly or up to n times\n\nIterators terminating on the shortest input sequence:\nizip(p, q, ...) --> (p[0], q[0]), (p[1], q[1]), ... \nifilter(pred, seq) --> elements of seq where pred(elem) is True\nifilterfalse(pred, seq) --> elements of seq where pred(elem) is False\nislice(seq, [start,] stop [, step]) --> elements from\n       seq[start:stop:step]\nimap(fun, p, q, ...) --> fun(p0, q0), fun(p1, q1), ...\nstarmap(fun, seq) --> fun(*seq[0]), fun(*seq[1]), ...\nchain(p, q, ...) --> p0, p1, ... plast, q0, q1, ... \ntakewhile(pred, seq) --> seq[0], seq[1], until pred fails\ndropwhile(pred, seq) --> seq[n],seq[n+1], starting when pred fails\ngroupby(iterable[, keyfunc]) -> create an iterator which returns\n(key, sub-iterator) grouped by each value of key(value).tee(iterable, n=2) --> tuple of n independent iterators.");
    public static PyString __doc__count = new PyString("count([firstval]) --> count object\n\nReturn a count object whose .next() method returns consecutive\nintegers starting from zero or, if specified, from firstval.");
    public static PyString __doc__cycle = new PyString("cycle(iterable) --> cycle object\n\nReturn elements from the iterable until itis exhausted.\nThen repeat the sequence indefinitely.");
    public static PyString __doc__chain = new PyString("chain(*iterables) --> chain object\n\nReturn a chain object whose .next() method returns elements from the\nfirst iterable until it is exhausted, then elements from the next\niterable, until all of the iterables are exhausted.");
    public static PyString __doc__repeat = new PyString("'repeat(element [,times]) -> create an iterator which returns the element\nfor the specified number of times.  If not specified, returns the element\nendlessly.");
    public static PyString __doc__imap = new PyString("'map(func, *iterables) --> imap object\n\nMake an iterator that computes the function using arguments from\neach of the iterables.\tLike map() except that it returns\nan iterator instead of a list and that it stops when the shortest\niterable is exhausted instead of filling in None for shorter\niterables.");
    public static PyString __doc__islice = new PyString("islice(iterable, [start,] stop [, step]) --> islice object\n\nReturn an iterator whose next() method returns selected values from an\niterable.  If start is specified, will skip all preceding elements;\notherwise, start defaults to zero.Step defaults to one.  If\nspecified as another value, step determines how manyvalues are \nskipped between successive calls.  Works like a slice() on a list\nbut returns an iterator.");
    public static PyString __doc__ifilter = new PyString("ifilter(function or None, sequence) --> ifilter object\n\nReturn those items of sequence for which function(item) is true.\nIf function is None, return the items that are true.");
    public static PyString __doc__ifilterfalse = new PyString("'ifilterfalse(function or None, sequence) --> ifilterfalse object\n\nReturn those items of sequence for which function(item) is false.\nIf function is None, return the items that are false.'");
    public static PyString __doc__izip = new PyString("izip(iter1 [,iter2 [...]]) --> izip object\n\nReturn an izip object whose .next() method returns a tuple where\nthe i-th element comes from the i-th iterable argument.  The .next()\nmethod continues until the shortest iterable in the argument sequence\nis exhausted and then it raises StopIteration.  Works like the zip()\nfunction but consumes less memory by returning an iterator instead of\na list.");
    public static PyString __doc__starmap = new PyString("starmap(function, sequence) --> starmap object\n\nReturn an iterator whose values are returned from the function evaluated\nwith an argument tuple taken from the given sequence.");
    public static PyString __doc__dropwhile = new PyString("dropwhile(predicate, iterable) --> dropwhile object\n\nDrop items from the iterable while predicate(item) is true.\nAfterwards, return every element until theiterable is exhausted.");
    public static PyString __doc__takewhile = new PyString("takewhile(predicate, iterable) --> takewhile object\n\nReturn successive entries from an iterable as long as the \npredicate evaluates to true for each entry.");
    public static PyString __doc__groupby = new PyString("groupby(iterable[, keyfunc]) -> create an iterator which returns\n(key, sub-iterator) grouped by each value of key(value).");
    public static PyString __doc__tee = new PyString("tee(iterable, n=2) --> tuple of n independent iterators.");

    public static void classDictInit(PyObject pyObject) {
    }

    public static PyIterator count(final int n) {
        return new PyIterator(){
            int counter;
            {
                this.counter = n;
            }

            public PyObject __iternext__() {
                return new PyInteger(this.counter++);
            }

            public PyString __repr__() {
                return (PyString)Py.newString("count(%d)").__mod__(Py.newInteger(this.counter));
            }
        };
    }

    public static PyIterator count() {
        return itertools.count(0);
    }

    public static PyIterator cycle(final PyObject pyObject) {
        return new ItertoolsIterator(){
            List<PyObject> saved = new ArrayList<PyObject>();
            int counter = 0;
            PyObject iter = pyObject.__iter__();
            boolean save = true;

            public PyObject __iternext__() {
                if (this.save) {
                    PyObject pyObject2 = this.nextElement(this.iter);
                    if (pyObject2 != null) {
                        this.saved.add(pyObject2);
                        return pyObject2;
                    }
                    this.save = false;
                }
                if (this.saved.size() == 0) {
                    return null;
                }
                if (this.counter >= this.saved.size()) {
                    this.counter = 0;
                }
                return this.saved.get(this.counter++);
            }
        };
    }

    public static PyIterator chain(PyObject[] pyObjectArray) {
        final PyObject[] pyObjectArray2 = new PyObject[pyObjectArray.length];
        for (int i = 0; i < pyObjectArray.length; ++i) {
            pyObjectArray2[i] = pyObjectArray[i].__iter__();
        }
        return new ItertoolsIterator(){
            int iteratorIndex = 0;

            public PyObject __iternext__() {
                PyObject pyObject = null;
                while (this.iteratorIndex < pyObjectArray2.length && (pyObject = this.nextElement(pyObjectArray2[this.iteratorIndex])) == null) {
                    ++this.iteratorIndex;
                }
                return pyObject;
            }
        };
    }

    public static PyIterator repeat(final PyObject pyObject, final int n) {
        return new PyIterator(){
            int counter;
            {
                this.counter = n;
            }

            public PyObject __iternext__() {
                if (this.counter > 0) {
                    --this.counter;
                    return pyObject;
                }
                return null;
            }

            public int __len__() {
                return n;
            }

            public PyString __repr__() {
                return (PyString)Py.newString("repeat(%r, %d)").__mod__(new PyTuple(pyObject, Py.newInteger(this.counter)));
            }
        };
    }

    public static PyIterator repeat(final PyObject pyObject) {
        return new PyIterator(){

            public PyObject __iternext__() {
                return pyObject;
            }

            public PyString __repr__() {
                return (PyString)Py.newString("repeat(%r)").__mod__(new PyTuple(pyObject));
            }
        };
    }

    public static PyIterator imap(PyObject[] pyObjectArray) {
        final int n = pyObjectArray.length - 1;
        if (n < 1) {
            throw Py.TypeError("imap requires at least two arguments");
        }
        final PyObject pyObject = pyObjectArray[0];
        final PyObject[] pyObjectArray2 = new PyObject[n];
        for (int i = 0; i < n; ++i) {
            pyObjectArray2[i] = Py.iter(pyObjectArray[i + 1], "argument " + (i + 1) + " to imap() must support iteration");
        }
        return new PyIterator(){
            PyObject[] args;
            PyObject element;
            {
                this.args = new PyObject[n];
                this.element = null;
            }

            public PyObject __iternext__() {
                for (int i = 0; i < n; ++i) {
                    this.element = pyObjectArray2[i].__iternext__();
                    if (this.element == null) {
                        return null;
                    }
                    this.args[i] = this.element;
                }
                if (pyObject == Py.None) {
                    if (n == 1) {
                        return this.args[0];
                    }
                    return new PyTuple((PyObject[])this.args.clone());
                }
                return pyObject.__call__(this.args);
            }
        };
    }

    private static int py2int(PyObject pyObject, int n, String string) {
        if (pyObject instanceof PyNone) {
            return n;
        }
        int n2 = n;
        try {
            n2 = Py.py2int(pyObject);
        }
        catch (PyException pyException) {
            if (pyException.match(Py.TypeError)) {
                throw Py.ValueError(string);
            }
            throw pyException;
        }
        return n2;
    }

    public static PyIterator islice(final PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
        final int n = itertools.py2int(pyObject3, 0, "Stop argument must be a non-negative integer or None");
        final int n2 = itertools.py2int(pyObject2, 0, "Start argument must be a non-negative integer or None");
        final int n3 = itertools.py2int(pyObject4, 1, "Step argument must be a non-negative integer or None");
        final boolean bl = pyObject3 instanceof PyNone;
        if (n2 < 0 || n3 < 0 || n < 0) {
            throw Py.ValueError("Indices for islice() must be non-negative integers");
        }
        if (n3 == 0) {
            throw Py.ValueError("Step must be one or larger for islice()");
        }
        return new ItertoolsIterator(){
            int counter;
            int lastCount;
            PyObject iter;
            {
                this.counter = n2;
                this.lastCount = 0;
                this.iter = pyObject.__iter__();
            }

            public PyObject __iternext__() {
                PyObject pyObject2 = null;
                if (this.counter >= n && !bl) {
                    return null;
                }
                while (this.lastCount <= this.counter) {
                    pyObject2 = this.nextElement(this.iter);
                    ++this.lastCount;
                }
                this.counter += n3;
                return pyObject2;
            }
        };
    }

    public static PyIterator islice(PyObject pyObject, PyObject pyObject2) {
        return itertools.islice(pyObject, new PyInteger(0), pyObject2, new PyInteger(1));
    }

    public static PyIterator islice(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        return itertools.islice(pyObject, pyObject2, pyObject3, new PyInteger(1));
    }

    public static PyIterator ifilter(PyObject pyObject, PyObject pyObject2) {
        return new FilterIterator(pyObject, pyObject2, true);
    }

    public static PyIterator ifilterfalse(PyObject pyObject, PyObject pyObject2) {
        return new FilterIterator(pyObject, pyObject2, false);
    }

    public static PyIterator izip(PyObject[] pyObjectArray) {
        final int n = pyObjectArray.length;
        if (n == 0) {
            return (PyIterator)new PyXRange(0).__iter__();
        }
        final PyObject[] pyObjectArray2 = new PyObject[n];
        for (int i = 0; i < n; ++i) {
            PyObject pyObject = pyObjectArray[i].__iter__();
            if (pyObject == null) {
                throw Py.TypeError("izip argument #" + (i + 1) + " must support iteration");
            }
            pyObjectArray2[i] = pyObject;
        }
        return new ItertoolsIterator(){

            public PyObject __iternext__() {
                if (n == 0) {
                    return null;
                }
                PyObject[] pyObjectArray = new PyObject[n];
                for (int i = 0; i < n; ++i) {
                    PyObject pyObject = this.nextElement(pyObjectArray2[i]);
                    if (pyObject == null) {
                        return null;
                    }
                    pyObjectArray[i] = pyObject;
                }
                return new PyTuple(pyObjectArray);
            }
        };
    }

    public static PyIterator starmap(PyObject[] pyObjectArray) {
        if (pyObjectArray.length != 2) {
            throw Py.TypeError("starmap requires 2 arguments, got " + pyObjectArray.length);
        }
        final PyObject pyObject = pyObjectArray[0];
        final PyObject pyObject2 = pyObjectArray[1].__iter__();
        return new ItertoolsIterator(){

            public PyObject __iternext__() {
                PyObject pyObject3 = this.nextElement(pyObject2);
                PyObject pyObject22 = null;
                if (pyObject3 != null) {
                    if (!pyObject3.getClass().isAssignableFrom(PyTuple.class)) {
                        throw Py.TypeError("iterator must return a tuple");
                    }
                    PyTuple pyTuple = (PyTuple)pyObject3;
                    pyObject22 = pyObject.__call__(pyTuple.getArray());
                }
                return pyObject22;
            }
        };
    }

    public static PyIterator dropwhile(PyObject pyObject, PyObject pyObject2) {
        return new WhileIterator(pyObject, pyObject2, true);
    }

    public static PyIterator takewhile(PyObject pyObject, PyObject pyObject2) {
        return new WhileIterator(pyObject, pyObject2, false);
    }

    public static PyIterator groupby(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("groupby", pyObjectArray, stringArray, "iterable", "key");
        if (pyObjectArray.length > 2) {
            throw Py.TypeError("groupby takes two arguments, iterable and key");
        }
        PyObject pyObject = argParser.getPyObject(0);
        PyObject pyObject2 = argParser.getPyObject(1, null);
        return new GroupBy(pyObject, pyObject2);
    }

    public static PyTuple tee(PyObject pyObject, int n) {
        return new PyTuple((PyObject[])PyTeeIterator.makeTees(pyObject, n));
    }

    public static PyTuple tee(PyObject pyObject) {
        return itertools.tee(pyObject, 2);
    }

    static class FilterIterator
    extends ItertoolsIterator {
        private PyObject predicate;
        private PyObject iterator;
        private boolean filterTrue;

        FilterIterator(PyObject pyObject, PyObject pyObject2, boolean bl) {
            this.predicate = pyObject instanceof PyNone ? null : pyObject;
            this.iterator = pyObject2.__iter__();
            this.filterTrue = bl;
        }

        public PyObject __iternext__() {
            PyObject pyObject;
            while ((pyObject = this.nextElement(this.iterator)) != null) {
                boolean bl = this.predicate != null ? this.predicate.__call__(pyObject).__nonzero__() : pyObject.__nonzero__();
                if (bl != this.filterTrue) continue;
                return pyObject;
            }
            return null;
        }
    }

    private static final class GroupBy
    extends ItertoolsIterator {
        private final PyObject iterator;
        private final PyObject keyFunc;
        private PyObject currentKey;
        private PyObject currentValue;
        private PyObject targetKey;

        private GroupBy(PyObject pyObject, PyObject pyObject2) {
            this.iterator = pyObject.__iter__();
            this.keyFunc = pyObject2;
            this.currentKey = this.currentValue = new PyXRange(0);
            this.targetKey = this.currentValue;
        }

        public PyObject __iternext__() {
            while (this.currentKey.equals(this.targetKey)) {
                this.currentValue = this.nextElement(this.iterator);
                if (this.currentValue == null) {
                    return null;
                }
                if (this.keyFunc == null) {
                    this.currentKey = this.currentValue;
                    continue;
                }
                this.currentKey = this.keyFunc.__call__(this.currentValue);
            }
            this.targetKey = this.currentKey;
            return new PyTuple(this.currentKey, new GroupByIterator());
        }

        private class GroupByIterator
        extends ItertoolsIterator {
            private boolean completed = false;

            private GroupByIterator() {
            }

            public PyObject __iternext__() {
                PyObject pyObject = GroupBy.this.currentValue;
                if (this.completed) {
                    return null;
                }
                GroupBy.this.currentValue = this.nextElement(GroupBy.this.iterator);
                if (GroupBy.this.currentValue == null) {
                    this.completed = true;
                } else if (GroupBy.this.keyFunc == null) {
                    GroupBy.this.currentKey = GroupBy.this.currentValue;
                } else {
                    GroupBy.this.currentKey = GroupBy.this.keyFunc.__call__(GroupBy.this.currentValue);
                }
                if (!GroupBy.this.currentKey.equals(GroupBy.this.targetKey)) {
                    this.completed = true;
                }
                return pyObject;
            }
        }
    }

    static abstract class ItertoolsIterator
    extends PyIterator {
        ItertoolsIterator() {
        }

        protected PyObject nextElement(PyObject pyObject) {
            PyObject pyObject2 = null;
            try {
                pyObject2 = pyObject.__iternext__();
            }
            catch (PyException pyException) {
                if (pyException.match(Py.StopIteration)) {
                    this.stopException = pyException;
                }
                throw pyException;
            }
            return pyObject2;
        }
    }

    static class WhileIterator
    extends ItertoolsIterator {
        private PyObject iterator;
        private PyObject predicate;
        private boolean drop;
        private boolean predicateSatisfied;

        WhileIterator(PyObject pyObject, PyObject pyObject2, boolean bl) {
            this.predicate = pyObject;
            this.iterator = pyObject2.__iter__();
            this.drop = bl;
        }

        public PyObject __iternext__() {
            PyObject pyObject;
            while ((pyObject = this.nextElement(this.iterator)) != null) {
                if (!this.predicateSatisfied) {
                    if (this.predicate.__call__(pyObject).__nonzero__() != this.drop) {
                        this.predicateSatisfied = this.drop;
                        return pyObject;
                    }
                    this.predicateSatisfied = !this.drop;
                    continue;
                }
                if (this.drop) {
                    return pyObject;
                }
                return null;
            }
            return null;
        }
    }
}

